//
//  GSContainerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 22.02.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSBase.h>

@class GSFont;
@class GSGlyph;
@class GSLayer;
@class GSShape;

NS_ASSUME_NONNULL_BEGIN

@protocol GSContainerProtocol <NSObject>

@optional

- (GSGlyph *)glyph;

- (GSLayer *)layer;

- (void)elementDidChange:(id)element;

@property (nonatomic, readonly) GSFont *font;

#ifndef GLYPHS_VIEWER
@property (nonatomic, readonly, nullable) NSUndoManager *undoManager;
@property (nonatomic, readonly, nullable) NSUndoManager *undoManagerCheck;
#endif

@end

typedef NSObject<GSContainerProtocol> GSContainer;

@protocol GSItemProtocol <NSObject>

/// init from property list
- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;

#ifndef GLYPHS_VIEWER
/** Returns the content of the object to store it in pList.

 This is used to store the data in the .glyphs file.
 @param format the version of the dict
 */
- (nullable NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;
#endif

@property (weak, nonatomic) GSContainer *parent;

#ifndef GLYPHS_VIEWER
@property (nonatomic, readonly, nullable) NSUndoManager *undoManager;
#endif

@optional

- (void)postRead:(GSFormatVersion)formatVersion;

@end

NS_ASSUME_NONNULL_END
